/****************************************************************************\ 
 *** 
 *** File                  : rtosal_simengineap.cpp
 *** 
 *** Generated by dSPACE Tools.
 *** (c) Copyright 2013, dSPACE GmbH. All rights reserved.
\****************************************************************************/

#if !defined(RTOSAL_SIMENGINEAP_CPP_)
#  define    RTOSAL_SIMENGINEAP_CPP_


/* -- Include directives. -- */
#  include "rtosal_task.h"
#  include "dssimengine_api.h"
#  include "IOCode_Data.h"
#  include "rtosal_msg.h"
#  include "rtosal_simengineap.h"

#  if defined(EXTERN_C_DECL)
#    undef EXTERN_C_DECL
#  endif
#  if defined(__cplusplus)
#    define EXTERN_C_DECL extern "C"
#  else
#    define EXTERN_C_DECL extern
#  endif


/* -- Defines and directives in module scope. After include directives. -- */
DSRTT_DEFINE_ENABLE_RTT_COMMUNICATION(g_dsrtt_comm_enabled, 1,
{1})

/* -- Variable declarations in module scope. -- */
double ScaledTimeInterval = 0;
double ScalingFactor = 1;

/* Task information variables for task: Periodic Task 1 */
DsSTaskVariables Periodic_Task_1Vars;

/* Task information variables for task: Bus Configuration */
DsSTaskVariables Bus_ConfigurationVars;

/* Task information variables for task: CAN RX Task (1) */
DsSTaskVariables CAN_RX_Task_i1_Vars;

/* -- Definitions of exported functions. -- */

  void
RtosAlOnInit(
    DsTErrorList ErrorList) 
{
    /* Get application object */
    DsCApplication* pAppl = SimEngineApplGet();

    /* Create and configure task: Periodic Task 1 (Source: User default) */
    pRtosAlPeriodic_Task_1 = DsCRtosAlPeriodic_Task_1::create(ErrorList, 
    pAppl,
    "Periodic Task 1 (Source: User default)", 
    (UInt32) 40, 
    (UInt32) 0, 
    (UInt32) 0,
    (UInt32) DsNTask::SchedulingPolicy::FirstComeFirstServe, 
    (UInt32) DsNTask::OverrunMode::HandlerCall,
    (UInt32) 0,
    (UInt32) DsNTask::TaskType::Periodic,
    (DsCTask*) 0,
    (UInt32) 1048576);

    /* Create and configure task: Bus Configuration (Source: I/O function, Group: 9c15e614-46a2-4d08-a458-760a5cba9dc3) */
    pRtosAlBus_Configuration = DsCRtosAlBus_Configuration::create(ErrorList, 
    pAppl,
    "Bus Configuration (Source: I/O function, Group: 9c15e614-46a2-4d08-a458-760a5cba9dc3)", 
    (UInt32) 20, 
    (UInt32) 1, 
    (UInt32) 0,
    (UInt32) DsNTask::SchedulingPolicy::FirstComeFirstServe, 
    (UInt32) DsNTask::OverrunMode::HandlerCall,
    (UInt32) 0,
    (UInt32) DsNTask::TaskType::Periodic,
    (DsCTask*) 0,
    (UInt32) 1048576);

    /* Create and configure task: CAN RX Task (1) (Source: I/O function) */
    pRtosAlCAN_RX_Task_i1_ = DsCRtosAlCAN_RX_Task_i1_::create(ErrorList, 
    pAppl,
    "CAN RX Task (1) (Source: I/O function)", 
    (UInt32) 0, 
    (UInt32) 2, 
    (UInt32) 0,
    (UInt32) DsNTask::SchedulingPolicy::FirstComeFirstServe, 
    (UInt32) DsNTask::OverrunMode::HandlerCall,
    (UInt32) 0,
    (UInt32) DsNTask::TaskType::Aperiodic,
    (DsCTask*) pRtosAlPeriodic_Task_1,
    (UInt32) 0);

    /* Set task simulation time variable */

    pRtosAlPeriodic_Task_1->setSimTimeVariable(&RtosAlTaskSimTime_Periodic_Task_1);

    pRtosAlBus_Configuration->setSimTimeVariable(&RtosAlTaskSimTime_Bus_Configuration);

    /* Create and init timer driver and bind task to it */
    pRtosAlTimer_Periodic_Task_1 = DsCTimer::create(ErrorList, 0.01, 0.0);
    pRtosAlPeriodic_Task_1->bindTrigger(ErrorList, pRtosAlTimer_Periodic_Task_1);

    /* Create and init timer driver and bind task to it */
    pRtosAlTimer_Bus_Configuration = DsCTimer::create(ErrorList, 0.01, 0.0);
    pRtosAlBus_Configuration->bindTrigger(ErrorList, pRtosAlTimer_Bus_Configuration);
thermalCANcomplete_1_CAN_RX_TaskId = pRtosAlCAN_RX_Task_i1_->bindTrigger(ErrorList, pThermalCANcomplete_1_DriverHandle);

    /* Bind function modules to task: Periodic Task 1 */
    pRtosAlPeriodic_Task_1->bindFcnModule(ErrorList, control_system_2020_fcnModule_SIDRoot_TID1);

    /* Init task information variables of task: Periodic Task 1 */
    pRtosAlPeriodic_Task_1->setTaskVariables(ErrorList, &Periodic_Task_1Vars);
    DS_SET_TASK_VARIABLE_SYMBOLS(Periodic_Task_1Vars);

    /* Init task information variables of task: Bus Configuration */
    pRtosAlBus_Configuration->setTaskVariables(ErrorList, &Bus_ConfigurationVars);
    DS_SET_TASK_VARIABLE_SYMBOLS(Bus_ConfigurationVars);

    /* Init task information variables of task: CAN RX Task (1) */
    pRtosAlCAN_RX_Task_i1_->setTaskVariables(ErrorList, &CAN_RX_Task_i1_Vars);
    DS_SET_TASK_VARIABLE_SYMBOLS(CAN_RX_Task_i1_Vars);

    /* Set the deadline violation handler of task: pRtosAlPeriodic_Task_1 */
    pRtosAlPeriodic_Task_1->setDeadlineViolationFunction(ErrorList, &RtosAlDefaultDeadlineViolationHandler);

    /* Set the deadline violation handler of task: pRtosAlBus_Configuration */
    pRtosAlBus_Configuration->setDeadlineViolationFunction(ErrorList, &RtosAlDefaultDeadlineViolationHandler);

    /* Set the deadline violation handler of task: pRtosAlCAN_RX_Task_i1_ */
    pRtosAlCAN_RX_Task_i1_->setDeadlineViolationFunction(ErrorList, &RtosAlDefaultDeadlineViolationHandler);

    /* Initialize Profiler Sources */
#   ifdef TASK_ENABLE_PROFILING
    RtosAlProfilerSourcesInitialization();    
#   endif

    /* DSModelAccess initialization hook */
    (void)DS_MODEL_ACCESS_INIT();

}

  void
RtosAlOnStart(
    DsTErrorList ErrorList) 
{
    // Get the application object
    DsCApplication* pAppl = SimEngineApplGet();

    // Create local copies of variables
    double tmpScaledTimeInterval = ScaledTimeInterval;
    double tmpScalingFactor = ScalingFactor;

    // Perform range check for scaling variables
    if (0.0 > ScaledTimeInterval)
    {
        // Range check failed. Stop the application
        pAppl->errorMessage(RTOSAL_PARAM_OUT_OF_RANGE, "%s%f%s%s" , "ScaledTimeInterval" , ScaledTimeInterval, "0.0" , "Inf" );

        // Reset the local copy to the default value and leave the original unchanged
        tmpScaledTimeInterval = 0.0;
    }
    if (1.0 > ScalingFactor)
    {
        // Range check failed. Stop the application
        pAppl->errorMessage(RTOSAL_PARAM_OUT_OF_RANGE, "%s%f%s%s" , "ScalingFactor" , ScalingFactor, "1.0" , "Inf" );

        // Reset the local copy to the default value and leave the original unchanged
        tmpScalingFactor = 1.0;
    }

    // Set the startup slowdown parameters (local copies) to the realtime application
    pAppl->setSlowStart(ErrorList,tmpScaledTimeInterval,tmpScalingFactor);

    /* Init task simulation time variables */

    RtosAlTaskSimTime_Periodic_Task_1 = 0;
    StepCounter_Periodic_Task_1 = 0;

    RtosAlTaskSimTime_Bus_Configuration = 0;
    StepCounter_Bus_Configuration = 0;

}

#endif                                 /* RTOSAL_SIMENGINEAP_CPP_ */
/* [EOF] */
